			var ctWindow = document.getElementById("content_frame");
			var PptxHandle = undefined;
			var PptxEvtDispatcher = undefined;
			var moduleReady = false;
			var areEventListenersSuspended = false;
			var animationPlaying = false;
			var isScrubSeekPending = -1;
			var donotPropogateEvent = -1;
			var scrub = {};
			var currentSlideNum = 0;
			var type;
			
			isHybridContentType=function(){
				if(type === 'presentation-html' || type === 'producer-html')
					return false;
				return true;
			}
			
			callFnOnISlideInstanceWithParams=function(callName,paramsObj){
				console.log(callName);
			}
			
			toggleSidebar = function(visibility){
				if(!moduleReady)
					return;
				controlVisibility("toc",visibility);
			}

			enableSidebar = function(enable){
				if(!moduleReady)
					return;
				controlVisibility("disableSidebarNavigation",!enable);
			}

			togglePlaybar = function(visibility){
				if(!moduleReady)
					return;
				controlVisibility("playbar",visibility);
			}
			
			gotoSlide = function(index){
				if(!moduleReady)
					return;
				PptxHandle.navigateToItem(null, Number(index));
			}
			

			gotoScrubPosition = function(timeInMilliSecs, currentSlideNum){
				if(!moduleReady)
						return;
				currentSlideNum = Number(currentSlideNum);
                timeInMilliSecs = parseFloat(timeInMilliSecs);

				if(currentSlideNum){
					timeInMilliSecs = timeInMilliSecs + scrub[currentSlideNum];
				}
				PptxHandle.navigateToTime(timeInMilliSecs);
			}
			
			ignoreQuizWarningMessage = function(ignoreQuizWarning){
				if(!moduleReady)
					return;
				PptxHandle.ignoreQuizWarningMessage(ignoreQuizWarning);
			}
			
			setPPTSyncMode = function(syncMode){
				if(!moduleReady)
					return;

				PptxHandle.setSyncMode(syncMode);
				PptxHandle.forceAutoPlayAnim(syncMode);
				// setPlaying(false);
			}
			
			setPlayAndScrub = function(isPlaying,scrubTime, slideIndex){
				if(!moduleReady)
                    return;

                slideIndex = Number(slideIndex);
                scrubTime = parseFloat(scrubTime);
				setPlaying(isPlaying);
				if(slideIndex == PptxHandle.getCurrentSlideIndex()){
					if(isHybridContentType())
						gotoScrubPosition(scrubTime + parseInt(scrub[slideIndex]));
					else
						gotoScrubPosition(scrubTime);
				}
				else
				{
                    donotPropogateEvent = slideIndex;
                    gotoSlide(slideIndex);
                    if(slideIndex == PptxHandle.getCurrentSlideIndex())
                    {
                        donotPropogateEvent = -1;
                        if(isHybridContentType())
							gotoScrubPosition(scrubTime + parseInt(scrub[slideIndex]));
						else
							gotoScrubPosition(scrubTime);
                    }
                    else
                       isScrubSeekPending = scrubTime;
				}
			}
			
			setVolume = function(volume){
				if(!moduleReady)
					return;
				// Presenter right now only supports 2 volume modes , 0 and 100% i.e. only mute and unmute
				if(volume !== 0)
					volume = 100;
				PptxHandle.setVolume(Number(volume));
			}
			
			getSlideViewMetrics = function(viewMetricsObj){
				if(!moduleReady)
						return;

				var isDirty = true;

				var viewMetrics = getViewMetricsFromPresenter();

				isDirty = (viewMetricsObj === undefined) || (viewMetricsObj.left !== viewMetrics.left) || (viewMetricsObj.right !== viewMetrics.right) || (viewMetricsObj.top !== viewMetrics.top) || (viewMetricsObj.bottom !== viewMetrics.bottom);
				if(isDirty)
					dispatchPrEvent("getSlideViewMetrics",viewMetrics);
			}
			
			getViewMetricsFromPresenter = function(){
				if(!moduleReady)
					return;

				var viewMetrics = PptxHandle.getSlideViewMetrics();
				if(viewMetrics)
				{
					viewMetrics.left = viewMetrics.left.toFixed(3);
					viewMetrics.right = viewMetrics.right.toFixed(3);
					viewMetrics.top = viewMetrics.top.toFixed(3);
					viewMetrics.bottom = viewMetrics.bottom.toFixed(3);
				}
				return viewMetrics;
			}
			
			suspendEventListeners = function(){
				if(!moduleReady)
					return;

				areEventListenersSuspended = true;
			}
			
			resumeEventListeners = function(){
				if(!moduleReady)
						return;

				areEventListenersSuspended = false;
			}
			
			togglePlayState = function(){
				if(!moduleReady)
						return;

				if(PptxHandle.isPlaying())
					setPlaying(false);
				else
					setPlaying(true);
			}

			toggleVolume = function(){
				if(!moduleReady)
						return;

				if(PptxHandle.getVolume())
					PptxHandle.setVolume(0);
				else
					PptxHandle.setVolume(100);
			}
				
			
			
			controlVisibility = function(component, visibility){
				if(!moduleReady)
						return;

				switch(component)
				{
						case "toc":
								PptxHandle.controlVisibility("toc",visibility);
								break;

						case "playbar":
								PptxHandle.controlVisibility("playbar",visibility);
								break;

						case "titlebar":
								PptxHandle.controlVisibility("titlebar",visibility);
								break;

						case "disableSidebarNavigation":
								PptxHandle.controlVisibility("disableSidebarNavigation",visibility);
								break;
				}
			}
			
			close = function(){
				if(!moduleReady)
                    return;
				PptxHandle.close();
			}

			next = function(){
				if(!moduleReady)
                    return;

				PptxHandle.gotoNext();
			}
			
			previous = function(){
				if(!moduleReady)
                    return;

				PptxHandle.gotoPrev();
			}
		
			
			setPlaying = function(p_setPlaying){
				if(!moduleReady)
                   return;

				if(PptxHandle.isPlaying() == p_setPlaying)
                   return;

				if(p_setPlaying == true)
                   PptxHandle.play();
				else
                   PptxHandle.pause();
			}
			
			
			gotoScrubPosition = function(timeInMilliSecs){
				if(!moduleReady)
                    return;

				PptxHandle.navigateToTime(timeInMilliSecs);
			}
			
			// This is method which will invoke Mobile Function.
			dispatchPrEvent = function(evtType, evtData){
				if(evtData == null || evtData == undefined)
					evtData = {};
                var jsonData = {type : evtType, data : evtData};
                jsonData = JSON.stringify(jsonData);
				if (typeof Mobile !== 'undefined') {
					Mobile.disPatchPrEvent(jsonData);
				}
				else{
				    // for IOs device
				    window.webkit.messageHandlers.Mobile.postMessage(jsonData);
				}
			}
			
			// Mobile handler Function
			callFromMoble = function(param){
				var loop = param.FnCall;
				for(var i = 0 ; i< loop.length;i++){
					var obj = loop[i];
					var callName = obj["callName"];
					var paramsObj = obj["paramsObj"];
					this[callName].apply(this, paramsObj);
				}
			}
			
			getViewMetricsFromPresenter = function(){
				if(!moduleReady)
                    return;

				var viewMetrics = PptxHandle.getSlideViewMetrics();
				if(viewMetrics)
				{
                    viewMetrics.left = viewMetrics.left.toFixed(3);
                    viewMetrics.right = viewMetrics.right.toFixed(3);
                    viewMetrics.top = viewMetrics.top.toFixed(3);
                    viewMetrics.bottom = viewMetrics.bottom.toFixed(3);
				}
				return viewMetrics;
			}
			
			handleResumeDataEvent = function(eventData){
				eventData["callback"](new Promise(function(resolve, reject) {   
                                    resolve("");
                                    })
                                    );
			}
			
			handleConfigurationSettingsEvent = function(eventData){
			   var data = {};
			   data["settings"] = {};
			   data["settings"]["nextButtonAsNextAnim"] = true;
			   eventData["callback"].call(this,data);
			}
			
			capiEventListener = function(event){
				var eventName = event['Name'];
				var eventData = event['Data'];
				var relativeScrub;
				
				switch(eventName){
					case "CAPI_GET":
						if(eventData["ask"] == "resumeData")
							handleResumeDataEvent(eventData);
						else if(eventData["ask"] == "configurationSettings")
							handleConfigurationSettingsEvent(eventData);
						break;
					case "CAPI_MOVIESTART":
						PptxHandle.pause();
						dispatchPrEvent("pptStarted", {});
						dispatchPrEvent("volumeChanged", {volume : PptxHandle.getVolume()});
						break;
					case "CAPI_SLIDEVIEWMETRICSCHANGED":
						var viewMetrics = getViewMetricsFromPresenter();
						dispatchPrEvent("getSlideViewMetrics", viewMetrics);
						break;
					case "CAPI_SLIDEENTER":
						currentSlideNum = eventData.slideNumber;
						if(isHybridContentType()){
							scrub[event.Data.slideNumber] = event.Data.scrub;
						}
						if(areEventListenersSuspended && isScrubSeekPending > -1){
							if(isHybridContentType()){
								gotoScrubPosition(isScrubSeekPending + event.Data.scrub);
							}
							else
								gotoScrubPosition(isScrubSeekPending);
							isScrubSeekPending = -1;
							if(donotPropogateEvent == eventData.slideNumber)
								donotPropogateEvent = -1;
							
						}
						dispatchPrEvent("pageNumberUpdate", {slideNumber : currentSlideNum});
						break;
						
				}
				
				if(areEventListenersSuspended)
					return;
					
				switch(eventName){
					case "CAPI_VOLUMECHANGED":
					    dispatchPrEvent("volumeChanged",{volume : eventData.volume});
						break;
					case "CAPI_MOVIEPAUSE":
						var isFromHB = eventData.fromHB;
						var isAnim = false;
						if(animationPlaying){
							animationPlaying = false;
							isFromHB = false;
							isAnim = true;
						}
						relativeScrub = 0;
						if(isHybridContentType()){
							relativeScrub = eventData.scrub - scrub[currentSlideNum];
						}
						else
							relativeScrub = eventData.scrub;
							
						dispatchPrEvent("playStateChanged",{isAnim: isAnim, relativeScrub: relativeScrub, fromHB : isFromHB, scrub:eventData.scrub, isPlaying : PptxHandle.isPlaying()});
						break;
					
					case "CAPI_MOVIERESUME":
						dispatchPrEvent("playStateChanged",{fromHB : false, scrub : undefined, isPlaying : PptxHandle.isPlaying()});
						break;
						
					case "CAPI_MOVIESTOP":
						dispatchPrEvent("playStateChanged",{fromHB : false, scrub : undefined, isPlaying : PptxHandle.isPlaying()});
						break;
                
					case "CAPI_VIEWMODECHANGED":
						dispatchPrEvent("viewModeChanged", {mode : eventData.mode});
						break;
                
					case "CAPI_ISSCRUBBINGCHANGED":
						dispatchPrEvent("isScrubbingChanged", {fromHB : false, isScrubbing : eventData.isScrubbing});
						break;
						
					case "CAPI_SLIDEENTER":
						var slideInfo = PptxHandle.getSlideInfo(null,eventData.slideNumber);
						currentSlideNum = eventData.slideNumber;
						if(isHybridContentType()){
							scrub[event.Data.slideNumber] = event.Data.scrub;
						}
						if(donotPropogateEvent === eventData.slideNumber)
							donotPropogateEvent = -1;
						else{
							if(isHybridContentType()){
								dispatchPrEvent("slideChanged", {slideNumber : eventData.slideNumber, hidden : eventData.hidden, locked : eventData.locked, navid : eventData.navid, percentageSlideSeen  : eventData.percentageSlideSeen , slideType  : eventData.slideType, quizScope   : eventData.quizScope , fromHB   : eventData.fromHB, slideTitle : slideInfo.Title, scrub :eventData.scrub});
							
							}
							else{
								dispatchPrEvent("slideEntered", {slideNumber : eventData.slideNumber, hidden : eventData.hidden, locked : eventData.locked, navid : eventData.navid, percentageSlideSeen  : eventData.percentageSlideSeen , slideType  : eventData.slideType, quizScope   : eventData.quizScope , fromHB   : eventData.fromHB, slideTitle : slideInfo.Title, scrub :eventData.scrub});
							}
						}
	
							if(isScrubSeekPending > -1)
							{
								if(isHybridContentType()){
									gotoScrubPosition(isScrubSeekPending + event.Data.scrub);
								}
								else{
									gotoScrubPosition(isScrubSeekPending);
								}
								
								isScrubSeekPending  = -1;
							}
							break;
                
					case "CAPI_SYNCMODECHANGED":
						dispatchPrEvent("syncModeChanged",{syncMode : eventData.syncMode, time : eventData.time});
						break;
                    
                case "CAPI_SCRUBCHANGED":
					relativeScrub = 0;
					if(isHybridContentType()){
						relativeScrub = eventData.scrub - scrub[currentSlideNum];
					}
					else{
						relativeScrub = eventData.scrub;
					}
                    dispatchPrEvent("scrubChanged",{isPlaying : PptxHandle.isPlaying(), scrub : relativeScrub, fromHB : false});
                    break;
                
                case "CAPI_GOTOANIM":
                    animationPlaying = true;
                    break;
				case "CAPI_QUIZSLIDEREACHED":
					dispatchPrEvent("quizSlideReached", {});
                
                default:
                    break;
				}
			}
			
			function onModuleReadyEvent(event){
				PptxHandle = event.Data;
				PptxHandle._zname = "PrModule.PptxHandle";
				PptxEvtDispatcher = PptxHandle.getEventEmitter();
				PptxEvtDispatcher.addEventListener(capiEventListener);
				moduleReady = true;
				dispatchPrEvent("moduleReady");
				$(".loader").fadeOut("fast");  //Fade out the #loader div

			}
			
			getParameterByName = function(name, url){
				if (!url) url = window.location.href;
				name = name.replace(/[\[\]]/g, '\\$&');
				var regex = new RegExp('[?&]' + name + '(=([^&#]*)|&|#|$)'),
					results = regex.exec(url);
				if (!results) return null;
				if (!results[2]) return '';
				return decodeURIComponent(results[2].replace(/\+/g, ' '));
			}
		

           window.addEventListener("moduleReadyEvent",onModuleReadyEvent);


           const urlParams = new URLSearchParams(window.location.search);
           const userLanguage = urlParams.get('userLanguage');

           type = getParameterByName("contentType", window.location.search.slice(1))

            if(userLanguage){
                document.getElementById("content_frame").contentWindow.navigator.userLanguage=userLanguage;
            }
			
