class SyncConnector {

	static get VERSION(){
        return "2.0";
    }

    static get BUILD_NO(){
        return "2";
    }

    static get DATE(){
        var today = new Date();
        var dd = String(today.getDate()).padStart(2, '0');
        var mm = String(today.getMonth() + 1).padStart(2, '0');
        var yyyy = today.getFullYear();
        return mm + '/' + dd + '/' + yyyy;
    }

    /**
     *  Specifies that the role of user is Host of the meeting.
     */
    static get k_HOST(){
        return "owner";
    }

    /**
     *  Specifies that the role of user is Presenter of the meeting.
     */
    static get k_PRESENTER(){
        return "presenter";
    }

    /**
     *  Specifies that the role of user is Participant of the meeting.
     */
    static get k_PARTICIPANT(){
        return "viewer";
    }

    static get CAUGHT_UP(){
        return "caughtUp";
    }

    static get SYNC_MSG_RCVD(){
        return "syncMessageReceived";
    }


    /**
     *  Specifies <code>Raise Hand</code> as the desired status to set.
     */
    static get RAISE_HAND(){
        return "speechQuestion";
    }

    /**
     *  Specifies <code>Lower Hand</code> as the desired status to set.
     */
    static get LOWER_HAND(){
        return "speechQuestionLower";
    }

    /**
     *  Specifies <code>Agree</code> as the desired status to set.
     */
    static get AGREE(){
        return "speechAgree";
    }

    /**
     *  Specifies that <code>Agree</code> or <code>Disagree</code> status needs to be cleared.
     */
    static get AGREE_DISAGREE_CLEAR(){
        return "speechAgreeClear";
    }

    /**
     *  Specifies <code>Disagree</code> as the desired status to set.
     */
    static get DISAGREE(){
        return "speechDisagree";
    }

    /**
     *  Specifies <code>Step Away</code> as the desired status to set.
     */
    static get STEP_AWAY(){
        return "steppedAway";
    }

    /**
     *  Specifies <code>Step In</code> as the desired status to set.
     */
    static get STEP_IN(){
        return "stepIn";
    }

    /**
     *  Specifies <code>Speak Louder</code> as the desired status to set.
     */
    static get SPEAK_LOUDER(){
        return "speechLouder";
    }

    /**
     *  Specifies <code>Speak Softer</code> as the desired status to set.
     */
    static get SPEAK_SOFTER(){
        return "speechQuieter";
    }

    /**
     *  Specifies <code>Speed Up</code> as the desired status to set.
     */
    static get SPEED_UP(){
        return "speechFaster";
    }

    /**
     *  Specifies <code>Slow Down</code> as the desired status to set.
     */
    static get SLOW_DOWN(){
        return "speechSlower";
    }

    /**
     *  Specifies <code>Laughter</code> as the desired status to set.
     */
    static get LAUGHTER(){
        return "speechLaughter";
    }


    /**
     *  Specifies <code>Applause</code> as the desired status to set.
     */
    static get APPLAUSE(){
        return "speechApplause";
    }

    static get CLEAR_STATUS(){
        return "clearStatus";
    }

    constructor()
    {
        this.storedProperties = {
            isSynced: true,
            userID: -1,
            userName: "",
            role: "viewer",
            podWidth: -1,
            podHeight: -1,
            podMinWidth: -1,
            podMinHeight: -1,
            podTitle: "",
            podID: -1,
            isCaughtUp: false,
            isPointerOn: false,
            connectVersion: "",
            language: "",
            isAddin: false,
            isBreakoutSession: false,
            url: "",
            accountID: -1,
            roomSCOID: -1,
            isSecure: true,
            archiveDuration: 0,
            playState: "",
            sizeApplication: true,
            userList: [],
            breakoutRoomsList: [],
            isWhiteBoardOn: false,
            isArchive: false,
        };
    }

    get k_HOST()
    {
        return SyncConnector.k_HOST;
    }

    get k_PARTICIPANT()
    {
        return SyncConnector.k_PARTICIPANT;
    }

    get k_PRESENTER()
    {
        return SyncConnector.k_PRESENTER;
    }

    get language()
        {
            return this._language ?? "en";
        }

    // user status constants

    get AGREE()
    {
        return SyncConnector.AGREE;
    }

    get AGREE_DISAGREE_CLEAR()
    {
        return SyncConnector.AGREE_DISAGREE_CLEAR;
    }

    get APPLAUSE()
    {
        return SyncConnector.APPLAUSE;
    }

    get BUILD_NO()
    {
        return SyncConnector.BUILD_NO;
    }

    get CLEAR_STATUS()
    {
        return SyncConnector.CLEAR_STATUS;
    }

    get DATE()
    {
        return SyncConnector.DATE;
    }

    get DISAGREE()
    {
        return SyncConnector.DISAGREE;
    }

    get LAUGHTER()
    {
        return SyncConnector.LAUGHTER;
    }

    get LOWER_HAND()
    {
        return SyncConnector.LOWER_HAND;
    }

    get RAISE_HAND()
    {
        return SyncConnector.RAISE_HAND;
    }

    get SLOW_DOWN()
    {
        return SyncConnector.SLOW_DOWN;
    }

    get SPEAK_SOFTER()
    {
        return SyncConnector.SPEAK_SOFTER;
    }

    get SPEED_UP()
    {
        return SyncConnector.SPEED_UP;
    }

    get STEP_AWAY()
    {
        return SyncConnector.STEP_AWAY;
    }

    get STEP_IN()
    {
        return SyncConnector.STEP_IN;
    }

    get VERSION()
    {
        return SyncConnector.VERSION;
    }

    // properties and variables.
    get _accountID()
    {
        return this.storedProperties.accountID;
    }

    get _archiveDuration()
    {
        return this.storedProperties.archiveDuration;
    }


    get _isBreakoutSession()
    {
        return this.storedProperties.isBreakoutSession;
    }

    get _isCaughtUp()
    {
        return this.storedProperties.isCaughtUp;
    }

    get _isPointerOn()
    {
        return this.storedProperties.isPointerOn;
    }

    get _isSecure()
    {
        return this.storedProperties.isSecure;
    }

    get _isWhiteBoardOn()
    {
        return this.storedProperties.isWhiteBoardOn;
    }

    get _language()
    {
        return this.storedProperties.language;
    }

    get _playState()
    {
        return this.storedProperties.playState;
    }

    get _podTitle()
    {
        return this.storedProperties.podTitle;
    }

    get _role()
    {
        console.log(this.storedProperties.role);
        return this.storedProperties.role;
    }

    get _roomSCOID()
    {
        return this.storedProperties.roomSCOID;
    }

    get _url()
    {
        return this.storedProperties.url;
    }

    get _userID()
    {
        console.log(this.storedProperties.userID);
        return this.storedProperties.userID;
    }

    get _userName()
    {
        console.log(this.storedProperties.userName);
       return this.storedProperties.userName;
    }

    get _isArchive()
    {
        return this.storedProperties.isArchive;
    }

    get _userList()
    {
        return this.storedProperties.userList;
    }

    get _podHeight()
    {
        return this.storedProperties.podHeight;
    }

    get _podWidth()
    {
        return this.storedProperties.podWidth;
    }

    get _podMinWidth()
    {
        return this.storedProperties.podMinWidth;
    }

    get _podMinHeight()
    {
        return this.storedProperties.podMinHeight;
    }

    get _podID()
    {
        return this.storedProperties.podID;
    }

    get _isSynced()
    {
        return this.storedProperties.isSynced;
    }

    get _connectVersion()
    {
        return this.storedProperties.connectVersion;
    }

    get _archiveDuration()
    {
        return this.storedProperties.archiveDuration;
    }

    fire(event, data)
    {
         if(data == null || data == undefined)
            data = {};

        let jsonEvent = {
        bubbles: event.bubbles,
        cancelable: event.cancelable,
        composed: event.composed,
        currentTarget: event.currentTarget,
        defaultPrevented: event.defaultPrevented,
        detail: event.detail,
        isTrusted: event.isTrusted,
        returnValue: event.returnValue,
        srcElement: event.srcElement,
        target: event.target,
        timeStamp: event.timeStamp,
        type: event.type,
        };
        console.log("in  fire ")
        				if (typeof Mobile !== 'undefined') {
        					Mobile.fire(JSON.stringify({ event: jsonEvent, data: data }));
        				}
        				else{
        				// For the iOS
                                window.webkit.messageHandlers.observer.postMessage(jsonData);
                        }
                        return;
    }

    getUserDetails(userID)
    {
        if (this._role != SyncConnector.k_HOST) {
            return null;
        }
        return this.storedProperties.userList.find(element => element.id === userID);
    }

    getUserList()
    {
        if (this._role != SyncConnector.k_HOST) {
            return null;
        }
        return this.storedProperties.userList;
    }

    getMyUserDetails()
    {
        if(storedProperties.userID!=-1){
        return this.storedProperties.userList.find(element => element.id === this.storedProperties.userID);
        }
    }

    getBreakoutRoomDetails(breakoutId)
    {
        if (this._role != SyncConnector.k_HOST) {
            return null;
        }
        return this.storedProperties.breakoutRoomsList.find(element => element.id === breakoutId);
    }

    getBreakoutRoomsList()
    {
        if (this._role != SyncConnector.k_HOST) {
            return null;
        }
        return this.storedProperties.breakoutRoomsList;
    }

    getMyBreakoutRoomDetails()
    {
        return this.storedProperties.breakoutRoomsList.find(element => element.id === this.getUserDetails(this.storedProperties.userID).breakoutId);
    }
}
			let syncConnector = new SyncConnector();
			window['syncConnector'] = syncConnector;
			// Mobile Application -> CustomPod Layer.
			// invoke function expose to CustomPod.
			invoke = function(method, args) {
				let connector = document.getElementById('customPod').contentWindow.ConnectCustomSDK.SyncConnector;
				connector.invoke(method, args);
			}

			loadURL = function(url) {
				document.getElementById('customPod').src = url;
			}

            loadParams = function(params) {
                window['syncConnector'].storedProperties = params;
            }

            updateParams = function(params) {
                for (const [key, value] of Object.entries(params)) {
                    window['syncConnector'].storedProperties[key] = value;
            }
		}